<?php
/**
 * اسکریپت به‌روزرسانی دیتابیس برای قابلیت‌های جدید
 * - اضافه کردن فیلد بیوگرافی به جدول کاربران
 * - اضافه کردن فیلد ended_at به جدول گفتگوها
 * - اضافه کردن فیلد last_dice_time برای قابلیت سکه شانسی
 */

require_once '../include/settings.php';
require_once '../include/config.php';

echo "شروع به‌روزرسانی دیتابیس...\n\n";

// بررسی و اضافه کردن فیلد bio به جدول users
try {
    $checkBio = $conn->query("SHOW COLUMNS FROM ".users." LIKE 'bio'");
    if($checkBio->rowCount() == 0){
        $conn->exec("ALTER TABLE ".users." ADD COLUMN bio TEXT COLLATE utf8mb4_general_ci AFTER age");
        echo "✅ فیلد bio با موفقیت به جدول users اضافه شد.\n";
    } else {
        echo "ℹ️ فیلد bio قبلاً وجود دارد.\n";
    }
} catch (Exception $e) {
    echo "❌ خطا در اضافه کردن فیلد bio: " . $e->getMessage() . "\n";
}

// بررسی و اضافه کردن فیلد ended_at به جدول chats
try {
    $checkEnded = $conn->query("SHOW COLUMNS FROM ".chats." LIKE 'ended_at'");
    if($checkEnded->rowCount() == 0){
        $conn->exec("ALTER TABLE ".chats." ADD COLUMN ended_at INT(11) DEFAULT NULL AFTER status");
        echo "✅ فیلد ended_at با موفقیت به جدول chats اضافه شد.\n";
    } else {
        echo "ℹ️ فیلد ended_at قبلاً وجود دارد.\n";
    }
} catch (Exception $e) {
    echo "❌ خطا در اضافه کردن فیلد ended_at: " . $e->getMessage() . "\n";
}

// بررسی و اضافه کردن فیلد started_at به جدول chats
try {
    $checkStarted = $conn->query("SHOW COLUMNS FROM ".chats." LIKE 'started_at'");
    if($checkStarted->rowCount() == 0){
        $conn->exec("ALTER TABLE ".chats." ADD COLUMN started_at INT(11) DEFAULT NULL AFTER created_at");
        echo "✅ فیلد started_at با موفقیت به جدول chats اضافه شد.\n";
    } else {
        echo "ℹ️ فیلد started_at قبلاً وجود دارد.\n";
    }
} catch (Exception $e) {
    echo "❌ خطا در اضافه کردن فیلد started_at: " . $e->getMessage() . "\n";
}

// بررسی و اضافه کردن فیلد last_dice_time به جدول users برای قابلیت سکه شانسی
try {
    $checkDice = $conn->query("SHOW COLUMNS FROM ".users." LIKE 'last_dice_time'");
    if($checkDice->rowCount() == 0){
        $conn->exec("ALTER TABLE ".users." ADD COLUMN last_dice_time INT(11) DEFAULT 0 AFTER is_coin_comprof");
        echo "✅ فیلد last_dice_time با موفقیت به جدول users اضافه شد.\n";
    } else {
        echo "ℹ️ فیلد last_dice_time قبلاً وجود دارد.\n";
    }
} catch (Exception $e) {
    echo "❌ خطا در اضافه کردن فیلد last_dice_time: " . $e->getMessage() . "\n";
}

echo "\nبه‌روزرسانی دیتابیس با موفقیت انجام شد! 🎉\n";
?>
